/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.time.ParsedDuring;

public class EnableOperation
implements Operation {
    private final String stream;
    private final Optional<ParsedDuring> duringMaybe;

    public EnableOperation(String stream) {
        this.stream = stream;
        this.duringMaybe = Optional.empty();
    }

    public EnableOperation(String stream, ParsedDuring during) {
        this.stream = stream;
        this.duringMaybe = Optional.of(during);
    }

    public String getStream() {
        return this.stream;
    }

    @Override
    public void execute(PushDownMachine machine) {
        ParsedDuring parsedDuring = this.duringMaybe.orElseGet(() -> new ParsedDuring(Optional.empty(), Optional.empty()));
        YearMatcher yearMatcher = parsedDuring.buildYearMatcher(machine);
        Engine engine = machine.getEngine();
        engine.enable(this.stream, Optional.ofNullable(yearMatcher));
    }
}

