/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;

public class EqualityOperation
implements Operation {
    private final Operation left;
    private final Operation right;
    private final String operator;

    public EqualityOperation(Operation left, Operation right, String operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Override
    public void execute(PushDownMachine machine) {
        this.left.execute(machine);
        this.right.execute(machine);
        switch (this.operator) {
            case "==": {
                machine.equals();
                break;
            }
            case "!=": {
                machine.notEquals();
                break;
            }
            case ">": {
                machine.greaterThan();
                break;
            }
            case "<": {
                machine.lessThan();
                break;
            }
            case ">=": {
                machine.greaterThanOrEqual();
                break;
            }
            case "<=": {
                machine.lessThanOrEqual();
                break;
            }
            default: {
                throw new RuntimeException("Unknown equality operator: " + this.operator);
            }
        }
    }
}

