/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.time.ParsedDuring;

public class FloorOperation
implements Operation {
    private final String stream;
    private final Operation valueOperation;
    private final Optional<String> displaceTarget;
    private final Optional<ParsedDuring> duringMaybe;

    public FloorOperation(String stream, Operation valueOperation) {
        this.stream = stream;
        this.valueOperation = valueOperation;
        this.displaceTarget = Optional.empty();
        this.duringMaybe = Optional.empty();
    }

    public FloorOperation(String stream, Operation valueOperation, String displaceTarget) {
        this.stream = stream;
        this.valueOperation = valueOperation;
        this.displaceTarget = Optional.ofNullable(displaceTarget);
        this.duringMaybe = Optional.empty();
    }

    public FloorOperation(String stream, Operation valueOperation, ParsedDuring during) {
        this.stream = stream;
        this.valueOperation = valueOperation;
        this.displaceTarget = Optional.empty();
        this.duringMaybe = Optional.of(during);
    }

    public FloorOperation(String stream, Operation valueOperation, String displaceTarget, ParsedDuring during) {
        this.stream = stream;
        this.valueOperation = valueOperation;
        this.displaceTarget = Optional.ofNullable(displaceTarget);
        this.duringMaybe = Optional.of(during);
    }

    @Override
    public void execute(PushDownMachine machine) {
        this.valueOperation.execute(machine);
        EngineNumber result = machine.getResult();
        String units = result.getUnits();
        if (units != null && units.endsWith("eachyear")) {
            String actualUnit = units.replace("eachyear", "");
            result = new EngineNumber(result.getValue(), actualUnit);
        }
        ParsedDuring parsedDuring = this.duringMaybe.orElseGet(() -> new ParsedDuring(Optional.empty(), Optional.empty()));
        YearMatcher yearMatcher = parsedDuring.buildYearMatcher(machine);
        Engine engine = machine.getEngine();
        engine.floor(this.stream, result, yearMatcher, this.displaceTarget.orElse(null));
    }
}

