/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.Scope;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;

public class GetStreamOperation
implements Operation {
    private final String streamName;
    private final Optional<String> units;
    private final Optional<String> targetSubstance;

    public GetStreamOperation(String streamName) {
        this.streamName = streamName;
        this.units = Optional.empty();
        this.targetSubstance = Optional.empty();
    }

    public GetStreamOperation(String streamName, String units) {
        this.streamName = streamName;
        this.units = Optional.of(units);
        this.targetSubstance = Optional.empty();
    }

    public GetStreamOperation(String streamName, String targetSubstance, String units) {
        this.streamName = streamName;
        this.targetSubstance = Optional.of(targetSubstance);
        this.units = Optional.of(units);
    }

    @Override
    public void execute(PushDownMachine machine) {
        Engine engine = machine.getEngine();
        boolean hasOtherScope = this.targetSubstance.isPresent();
        EngineNumber value = hasOtherScope ? this.executeWithOtherScope(engine) : this.executeSameScope(engine);
        machine.push(value);
    }

    private EngineNumber executeWithOtherScope(Engine engine) {
        Scope currentScope = engine.getScope();
        Scope targetScope = currentScope.getWithSubstance(this.targetSubstance.get());
        if (this.units.isPresent()) {
            return engine.getStream(this.streamName, Optional.of(targetScope), this.units);
        }
        return engine.getStream(this.streamName, Optional.of(targetScope), Optional.empty());
    }

    private EngineNumber executeSameScope(Engine engine) {
        if (this.units.isPresent()) {
            Scope scope = engine.getScope();
            return engine.getStream(this.streamName, Optional.of(scope), this.units);
        }
        return engine.getStream(this.streamName);
    }
}

