/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;

public class LimitOperation
implements Operation {
    private final Operation operand;
    private final Optional<Operation> lowerBound;
    private final Optional<Operation> upperBound;

    public LimitOperation(Operation operand, Operation lowerBound, Operation upperBound) {
        this.operand = operand;
        this.lowerBound = Optional.ofNullable(lowerBound);
        this.upperBound = Optional.ofNullable(upperBound);
    }

    public LimitOperation(Operation operand, Operation upperBound) {
        this.operand = operand;
        this.lowerBound = Optional.empty();
        this.upperBound = Optional.ofNullable(upperBound);
    }

    public LimitOperation(Operation operand, Operation lowerBound, boolean isLowerBound) {
        this.operand = operand;
        this.lowerBound = Optional.ofNullable(lowerBound);
        this.upperBound = Optional.empty();
    }

    @Override
    public void execute(PushDownMachine machine) {
        this.operand.execute(machine);
        EngineNumber value = machine.getResult();
        Optional<Object> lower = Optional.empty();
        if (this.lowerBound.isPresent()) {
            this.lowerBound.get().execute(machine);
            lower = Optional.of(machine.getResult());
        }
        Optional<Object> upper = Optional.empty();
        if (this.upperBound.isPresent()) {
            this.upperBound.get().execute(machine);
            upper = Optional.of(machine.getResult());
        }
        BigDecimal result = value.getValue();
        if (lower.isPresent() && result.compareTo(((EngineNumber)lower.get()).getValue()) < 0) {
            result = ((EngineNumber)lower.get()).getValue();
        }
        if (upper.isPresent() && result.compareTo(((EngineNumber)upper.get()).getValue()) > 0) {
            result = ((EngineNumber)upper.get()).getValue();
        }
        machine.push(new EngineNumber(result, value.getUnits()));
    }
}

