/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;

public class LogicalOperation
implements Operation {
    private final Operation left;
    private final Operation right;
    private final String operator;

    public LogicalOperation(Operation left, Operation right, String operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Override
    public void execute(PushDownMachine machine) {
        this.left.execute(machine);
        this.right.execute(machine);
        switch (this.operator) {
            case "and": {
                machine.and();
                break;
            }
            case "or": {
                machine.or();
                break;
            }
            case "xor": {
                machine.xor();
                break;
            }
            default: {
                throw new RuntimeException("Unknown logical operator: " + this.operator);
            }
        }
    }
}

