/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.time.ParsedDuring;

public class RechargeOperation
implements Operation {
    private final Operation volumeOperation;
    private final Operation intensityOperation;
    private final Optional<ParsedDuring> duringMaybe;

    public RechargeOperation(Operation volumeOperation, Operation intensityOperation) {
        this.volumeOperation = volumeOperation;
        this.intensityOperation = intensityOperation;
        this.duringMaybe = Optional.empty();
    }

    public RechargeOperation(Operation volumeOperation, Operation intensityOperation, ParsedDuring during) {
        this.volumeOperation = volumeOperation;
        this.intensityOperation = intensityOperation;
        this.duringMaybe = Optional.of(during);
    }

    @Override
    public void execute(PushDownMachine machine) {
        this.volumeOperation.execute(machine);
        EngineNumber volumeResult = machine.getResult();
        this.intensityOperation.execute(machine);
        EngineNumber intensityResult = machine.getResult();
        ParsedDuring parsedDuring = this.duringMaybe.orElseGet(() -> new ParsedDuring(Optional.empty(), Optional.empty()));
        YearMatcher yearMatcher = parsedDuring.buildYearMatcher(machine);
        Engine engine = machine.getEngine();
        engine.recharge(volumeResult, intensityResult, yearMatcher);
    }
}

