/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.time.ParsedDuring;

public class RecoverOperation
implements Operation {
    private final Operation volumeOperation;
    private final Operation yieldOperation;
    private final Optional<ParsedDuring> duringMaybe;
    private final RecoveryStage stage;
    private final Optional<Operation> inductionOperation;

    public RecoverOperation(Operation volumeOperation, Operation yieldOperation) {
        this.volumeOperation = volumeOperation;
        this.yieldOperation = yieldOperation;
        this.duringMaybe = Optional.empty();
        this.stage = RecoveryStage.RECHARGE;
        this.inductionOperation = Optional.empty();
    }

    public RecoverOperation(Operation volumeOperation, Operation yieldOperation, RecoveryStage stage) {
        this.volumeOperation = volumeOperation;
        this.yieldOperation = yieldOperation;
        this.duringMaybe = Optional.empty();
        this.stage = stage;
        this.inductionOperation = Optional.empty();
    }

    public RecoverOperation(Operation volumeOperation, Operation yieldOperation, ParsedDuring during) {
        this.volumeOperation = volumeOperation;
        this.yieldOperation = yieldOperation;
        this.duringMaybe = Optional.of(during);
        this.stage = RecoveryStage.RECHARGE;
        this.inductionOperation = Optional.empty();
    }

    public RecoverOperation(Operation volumeOperation, Operation yieldOperation, ParsedDuring during, RecoveryStage stage) {
        this.volumeOperation = volumeOperation;
        this.yieldOperation = yieldOperation;
        this.duringMaybe = Optional.of(during);
        this.stage = stage;
        this.inductionOperation = Optional.empty();
    }

    public RecoverOperation(Operation volumeOperation, Operation yieldOperation, Optional<Operation> inductionOperation) {
        this.volumeOperation = volumeOperation;
        this.yieldOperation = yieldOperation;
        this.duringMaybe = Optional.empty();
        this.stage = RecoveryStage.RECHARGE;
        this.inductionOperation = inductionOperation;
    }

    public RecoverOperation(Operation volumeOperation, Operation yieldOperation, RecoveryStage stage, Optional<Operation> inductionOperation) {
        this.volumeOperation = volumeOperation;
        this.yieldOperation = yieldOperation;
        this.duringMaybe = Optional.empty();
        this.stage = stage;
        this.inductionOperation = inductionOperation;
    }

    public RecoverOperation(Operation volumeOperation, Operation yieldOperation, ParsedDuring during, Optional<Operation> inductionOperation) {
        this.volumeOperation = volumeOperation;
        this.yieldOperation = yieldOperation;
        this.duringMaybe = Optional.of(during);
        this.stage = RecoveryStage.RECHARGE;
        this.inductionOperation = inductionOperation;
    }

    public RecoverOperation(Operation volumeOperation, Operation yieldOperation, ParsedDuring during, RecoveryStage stage, Optional<Operation> inductionOperation) {
        this.volumeOperation = volumeOperation;
        this.yieldOperation = yieldOperation;
        this.duringMaybe = Optional.of(during);
        this.stage = stage;
        this.inductionOperation = inductionOperation;
    }

    public RecoveryStage getStage() {
        return this.stage;
    }

    @Override
    public void execute(PushDownMachine machine) {
        this.volumeOperation.execute(machine);
        EngineNumber recoveryAmount = machine.getResult();
        this.yieldOperation.execute(machine);
        EngineNumber yieldRate = machine.getResult();
        EngineNumber inductionRate = this.handleInduction(machine);
        ParsedDuring parsedDuring = this.duringMaybe.orElseGet(() -> new ParsedDuring(Optional.empty(), Optional.empty()));
        YearMatcher yearMatcher = parsedDuring.buildYearMatcher(machine);
        Engine engine = machine.getEngine();
        engine.setInductionRate(inductionRate, this.stage);
        engine.recycle(recoveryAmount, yieldRate, yearMatcher, this.stage);
    }

    private EngineNumber handleInduction(PushDownMachine machine) {
        EngineNumber inductionRate = null;
        if (this.inductionOperation.isPresent()) {
            this.inductionOperation.get().execute(machine);
            inductionRate = machine.getResult();
            double induction = inductionRate.getValue().doubleValue();
            if (induction < 0.0 || induction > 100.0) {
                throw new IllegalArgumentException("Induction rate must be between 0% and 100%, got: " + induction + "%");
            }
        }
        return inductionRate;
    }

    public static enum RecoveryStage {
        EOL,
        RECHARGE;

    }
}

