/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.time.ParsedDuring;

public class ReplaceOperation
implements Operation {
    private final Operation amountOperation;
    private final String stream;
    private final String destinationSubstance;
    private final Optional<ParsedDuring> duringMaybe;

    public ReplaceOperation(Operation amountOperation, String stream, String destinationSubstance) {
        this.amountOperation = amountOperation;
        this.stream = stream;
        this.destinationSubstance = destinationSubstance;
        this.duringMaybe = Optional.empty();
    }

    public ReplaceOperation(Operation amountOperation, String stream, String destinationSubstance, ParsedDuring during) {
        this.amountOperation = amountOperation;
        this.stream = stream;
        this.destinationSubstance = destinationSubstance;
        this.duringMaybe = Optional.of(during);
    }

    @Override
    public void execute(PushDownMachine machine) {
        this.amountOperation.execute(machine);
        EngineNumber result = machine.getResult();
        ParsedDuring parsedDuring = this.duringMaybe.orElseGet(() -> new ParsedDuring(Optional.empty(), Optional.empty()));
        YearMatcher yearMatcher = parsedDuring.buildYearMatcher(machine);
        Engine engine = machine.getEngine();
        engine.replace(result, this.stream, this.destinationSubstance, yearMatcher);
    }
}

