/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.Scope;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.EngineSupportUtils;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.time.ParsedDuring;

public class RetireOperation
implements Operation {
    private final Operation amountOperation;
    private final Optional<ParsedDuring> duringMaybe;

    public RetireOperation(Operation amountOperation) {
        this.amountOperation = amountOperation;
        this.duringMaybe = Optional.empty();
    }

    public RetireOperation(Operation amountOperation, ParsedDuring during) {
        this.amountOperation = amountOperation;
        this.duringMaybe = Optional.of(during);
    }

    @Override
    public void execute(PushDownMachine machine) {
        this.amountOperation.execute(machine);
        EngineNumber result = machine.getResult();
        ParsedDuring parsedDuring = this.duringMaybe.orElseGet(() -> new ParsedDuring(Optional.empty(), Optional.empty()));
        YearMatcher yearMatcher = parsedDuring.buildYearMatcher(machine);
        Engine engine = machine.getEngine();
        if (!EngineSupportUtils.getIsInRange(yearMatcher, engine.getYear())) {
            return;
        }
        this.handleMixedReplacement(engine);
        engine.retire(result, yearMatcher);
    }

    private void handleMixedReplacement(Engine engine) {
        boolean currentReplacement;
        Scope scope;
        SimulationState simulationState = engine.getStreamKeeper();
        boolean retireCalculated = simulationState.getRetireCalculatedThisStep(scope = engine.getScope());
        if (retireCalculated && (currentReplacement = simulationState.getHasReplacementThisStep(scope))) {
            throw new RuntimeException("Cannot mix retire commands with and without replacement in same step for " + scope.getApplication() + "/" + scope.getSubstance());
        }
        simulationState.setHasReplacementThisStep(scope, false);
    }
}

