/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.operation;

import java.math.BigDecimal;
import java.util.Optional;
import org.kigalisim.engine.Engine;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.number.UnitConverter;
import org.kigalisim.engine.state.Scope;
import org.kigalisim.engine.state.SimulationState;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.engine.support.EngineSupportUtils;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.time.ParsedDuring;

public class RetireWithReplacementOperation
implements Operation {
    private final Operation amountOperation;
    private final Optional<ParsedDuring> duringMaybe;

    public RetireWithReplacementOperation(Operation amountOperation) {
        this.amountOperation = amountOperation;
        this.duringMaybe = Optional.empty();
    }

    public RetireWithReplacementOperation(Operation amountOperation, ParsedDuring during) {
        this.amountOperation = amountOperation;
        this.duringMaybe = Optional.of(during);
    }

    @Override
    public void execute(PushDownMachine machine) {
        this.amountOperation.execute(machine);
        ParsedDuring parsedDuring = this.duringMaybe.orElseGet(() -> new ParsedDuring(Optional.empty(), Optional.empty()));
        YearMatcher yearMatcher = parsedDuring.buildYearMatcher(machine);
        Engine engine = machine.getEngine();
        if (!EngineSupportUtils.getIsInRange(yearMatcher, engine.getYear())) {
            return;
        }
        this.handleMixedReplacement(engine);
        String targetUnits = this.determineTargetUnits(engine);
        UnitConverter unitConverter = EngineSupportUtils.createUnitConverterWithTotal(engine, "sales");
        this.handleReduction(machine, engine, yearMatcher, unitConverter, targetUnits);
    }

    private void handleMixedReplacement(Engine engine) {
        boolean currentReplacement;
        Scope scope;
        SimulationState simulationState = engine.getStreamKeeper();
        boolean retireCalculated = simulationState.getRetireCalculatedThisStep(scope = engine.getScope());
        if (retireCalculated && !(currentReplacement = simulationState.getHasReplacementThisStep(scope))) {
            throw new RuntimeException("Cannot mix retire commands with and without replacement in same step for " + scope.getApplication() + "/" + scope.getSubstance());
        }
        simulationState.setHasReplacementThisStep(scope, true);
    }

    private String determineTargetUnits(Engine engine) {
        Scope scope;
        SimulationState simulationState = engine.getStreamKeeper();
        EngineNumber lastSalesValue = simulationState.getLastSpecifiedValue(scope = engine.getScope(), "sales");
        if (lastSalesValue != null && lastSalesValue.hasEquipmentUnits()) {
            return "units";
        }
        return "kg";
    }

    private void handleReduction(PushDownMachine machine, Engine engine, YearMatcher yearMatcher, UnitConverter unitConverter, String targetUnits) {
        boolean hadReduction;
        EngineNumber equipmentBefore = unitConverter.convert(engine.getStream("equipment"), "units");
        EngineNumber retireAmount = machine.getResult();
        engine.retire(retireAmount, yearMatcher);
        EngineNumber equipmentAfter = unitConverter.convert(engine.getStream("equipment"), "units");
        BigDecimal actualReduction = equipmentBefore.getValue().subtract(equipmentAfter.getValue());
        boolean bl = hadReduction = actualReduction.compareTo(BigDecimal.ZERO) > 0;
        if (hadReduction) {
            EngineNumber replacementAmount = unitConverter.convert(new EngineNumber(actualReduction, "units"), targetUnits);
            engine.changeStream("sales", replacementAmount, yearMatcher);
        }
    }
}

