/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.kigalisim.lang.QubecTalkParser;
import org.kigalisim.lang.parse.ParseError;

public class ParseResult {
    private final Optional<QubecTalkParser.ProgramContext> program;
    private final List<ParseError> errors;

    public ParseResult(QubecTalkParser.ProgramContext program) {
        this.program = Optional.of(program);
        this.errors = new ArrayList<ParseError>();
    }

    public ParseResult(List<ParseError> errors) {
        if (errors.isEmpty()) {
            throw new IllegalArgumentException("Passed an empty errors list without parsed program.");
        }
        this.program = Optional.empty();
        this.errors = errors;
    }

    public Optional<QubecTalkParser.ProgramContext> getProgram() {
        return this.program;
    }

    public List<ParseError> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

