/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.program;

import java.util.Map;
import java.util.Set;
import org.kigalisim.lang.program.ParsedSubstance;
import org.kigalisim.lang.validation.DuplicateValidator;

public class ParsedApplication {
    private final String name;
    private final Map<String, ParsedSubstance> substances;

    public ParsedApplication(String name, Iterable<ParsedSubstance> substances) {
        this.name = name;
        this.substances = DuplicateValidator.validateUniqueNames(substances, ParsedSubstance::getName, "substance", "application '" + name + "'");
        DuplicateValidator.validateUniqueSubstanceEquipmentCombinations(substances, name);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getSubstances() {
        return this.substances.keySet();
    }

    public ParsedSubstance getSubstance(String name) {
        if (!this.substances.containsKey(name)) {
            throw new IllegalArgumentException("No substance named " + name);
        }
        return this.substances.get(name);
    }
}

