/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.program;

import java.util.Map;
import java.util.Set;
import org.kigalisim.lang.program.ParsedApplication;
import org.kigalisim.lang.validation.DuplicateValidator;

public class ParsedPolicy {
    private final String name;
    private final Map<String, ParsedApplication> applications;

    public ParsedPolicy(String name, Iterable<ParsedApplication> applications) {
        this.name = name;
        this.applications = DuplicateValidator.validateUniqueNames(applications, ParsedApplication::getName, "application", "policy '" + name + "'");
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getApplications() {
        return this.applications.keySet();
    }

    public ParsedApplication getApplication(String name) {
        if (!this.applications.containsKey(name)) {
            throw new IllegalArgumentException("No application named " + name);
        }
        return this.applications.get(name);
    }
}

