/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.program;

import java.util.Map;
import java.util.Set;
import org.kigalisim.lang.program.ParsedPolicy;
import org.kigalisim.lang.program.ParsedScenario;
import org.kigalisim.lang.validation.DuplicateValidator;

public class ParsedProgram {
    private final Map<String, ParsedPolicy> policies;
    private final Map<String, ParsedScenario> scenarios;

    public ParsedProgram(Iterable<ParsedPolicy> policies, Iterable<ParsedScenario> scenarios) {
        this.policies = DuplicateValidator.validateUniqueNames(policies, ParsedPolicy::getName, "policy", "program");
        this.scenarios = DuplicateValidator.validateUniqueNames(scenarios, ParsedScenario::getName, "scenario", "program");
    }

    public Set<String> getPolicies() {
        return this.policies.keySet();
    }

    public ParsedPolicy getPolicy(String name) {
        if (!this.policies.containsKey(name)) {
            throw new IllegalArgumentException("No policy named " + name);
        }
        return this.policies.get(name);
    }

    public Set<String> getScenarios() {
        return this.scenarios.keySet();
    }

    public ParsedScenario getScenario(String name) {
        if (!this.scenarios.containsKey(name)) {
            throw new IllegalArgumentException("No scenario named " + name);
        }
        return this.scenarios.get(name);
    }
}

