/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.program;

import java.util.Map;
import java.util.Set;
import org.kigalisim.lang.program.ParsedScenario;
import org.kigalisim.lang.validation.DuplicateValidator;

public class ParsedScenarios {
    private final Map<String, ParsedScenario> scenarios;

    public ParsedScenarios(Iterable<ParsedScenario> scenarios) {
        this.scenarios = DuplicateValidator.validateUniqueNames(scenarios, ParsedScenario::getName, "scenario", "simulations stanza");
    }

    public Set<String> getScenarios() {
        return this.scenarios.keySet();
    }

    public ParsedScenario getScenario(String name) {
        if (!this.scenarios.containsKey(name)) {
            throw new IllegalArgumentException("No scenario named " + name);
        }
        return this.scenarios.get(name);
    }
}

