/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.time;

import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;
import org.kigalisim.engine.state.YearMatcher;
import org.kigalisim.lang.machine.PushDownMachine;
import org.kigalisim.lang.time.TimePointFuture;
import org.kigalisim.lang.time.TimePointRealized;

public class ParsedDuring {
    private final Optional<TimePointFuture> start;
    private final Optional<TimePointFuture> end;

    public ParsedDuring(Optional<TimePointFuture> start, Optional<TimePointFuture> end) {
        this.start = start;
        this.end = end;
    }

    public Optional<TimePointFuture> getStart() {
        return this.start;
    }

    public Optional<TimePointFuture> getEnd() {
        return this.end;
    }

    private Optional<Integer> getStartYear(PushDownMachine machine) {
        Optional<Integer> startYear = Optional.empty();
        if (this.start.isPresent()) {
            TimePointRealized startRealized = this.start.get().realize(machine);
            if (startRealized.isDynamicCap()) {
                startYear = startRealized.getDynamicCap().equals("beginning") ? Optional.of(machine.getEngine().getStartYear()) : Optional.of(machine.getEngine().getEndYear());
            } else {
                EngineNumber startValue = startRealized.getPointValue();
                startYear = Optional.of(startValue.getValue().intValue());
            }
        }
        return startYear;
    }

    private Optional<Integer> getEndYear(PushDownMachine machine) {
        Optional<Integer> endYear = Optional.empty();
        if (this.end.isPresent()) {
            TimePointRealized endRealized = this.end.get().realize(machine);
            if (endRealized.isDynamicCap()) {
                endYear = endRealized.getDynamicCap().equals("beginning") ? Optional.of(machine.getEngine().getStartYear()) : Optional.of(machine.getEngine().getEndYear());
            } else {
                EngineNumber endValue = endRealized.getPointValue();
                endYear = Optional.of(endValue.getValue().intValue());
            }
        }
        return endYear;
    }

    public YearMatcher buildYearMatcher(PushDownMachine machine) {
        Optional<Integer> startYear = this.getStartYear(machine);
        Optional<Integer> endYear = this.getEndYear(machine);
        return new YearMatcher(startYear, endYear);
    }
}

