/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.time;

import java.util.Optional;
import org.kigalisim.engine.number.EngineNumber;

public class TimePointRealized {
    private final Optional<EngineNumber> pointValue;
    private final Optional<String> dynamicCap;

    public TimePointRealized(EngineNumber pointValue) {
        this.pointValue = Optional.of(pointValue);
        this.dynamicCap = Optional.empty();
    }

    public TimePointRealized(String dynamicCap) {
        this.dynamicCap = Optional.of(dynamicCap);
        this.pointValue = Optional.empty();
    }

    public boolean isDynamicCap() {
        if (this.dynamicCap.isPresent()) {
            assert (this.pointValue.isEmpty());
            return true;
        }
        if (this.pointValue.isPresent()) {
            assert (this.dynamicCap.isEmpty());
            return false;
        }
        throw new IllegalStateException("Encountered time point which has neither dynamic cap nor point value.");
    }

    public EngineNumber getPointValue() {
        return this.pointValue.orElseThrow();
    }

    public String getDynamicCap() {
        return this.dynamicCap.orElseThrow();
    }
}

