/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.validation;

public class DuplicateValidationException
extends RuntimeException {
    private final String duplicateType;
    private final String duplicateName;
    private final String context;

    public DuplicateValidationException(String duplicateType, String duplicateName, String context) {
        super(DuplicateValidationException.buildMessage(duplicateType, duplicateName, context));
        this.duplicateType = duplicateType;
        this.duplicateName = duplicateName;
        this.context = context;
    }

    public DuplicateValidationException(String duplicateType, String duplicateName, String context, String message) {
        super(message);
        this.duplicateType = duplicateType;
        this.duplicateName = duplicateName;
        this.context = context;
    }

    public String getDuplicateType() {
        return this.duplicateType;
    }

    public String getDuplicateName() {
        return this.duplicateName;
    }

    public String getContext() {
        return this.context;
    }

    private static String buildMessage(String duplicateType, String duplicateName, String context) {
        String contextQualifier = DuplicateValidationException.getContextQualifier(context);
        return String.format("Duplicate %s name '%s' found in %s. Each %s must have a unique name%s.", duplicateType, duplicateName, context, duplicateType, contextQualifier);
    }

    private static String getContextQualifier(String context) {
        if (context.startsWith("policy")) {
            return " within its policy";
        }
        if (context.startsWith("application")) {
            return " within its application";
        }
        return "";
    }
}

