/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.lang.validation;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.kigalisim.lang.operation.EnableOperation;
import org.kigalisim.lang.operation.Operation;
import org.kigalisim.lang.program.ParsedSubstance;
import org.kigalisim.lang.validation.DuplicateValidationException;

public class DuplicateValidator {
    public static <T> Map<String, T> validateUniqueNames(Iterable<T> items, Function<T, String> nameExtractor, String itemType, String context) {
        HashMap<String, T> result = new HashMap<String, T>();
        for (T item : items) {
            String name = nameExtractor.apply(item);
            if (result.containsKey(name)) {
                throw new DuplicateValidationException(itemType, name, context);
            }
            result.put(name, item);
        }
        return result;
    }

    public static void validateUniqueSubstanceEquipmentCombinations(Iterable<ParsedSubstance> substances, String applicationName) {
        HashSet<CallSite> seenCombinations = new HashSet<CallSite>();
        for (ParsedSubstance substance : substances) {
            String substanceName = substance.getName();
            Set<String> equipmentTypes = DuplicateValidator.getEnabledEquipmentTypes(substance);
            for (String equipmentType : equipmentTypes) {
                String combination = substanceName + "+" + equipmentType;
                if (seenCombinations.contains(combination)) {
                    String context = "application '" + applicationName + "'";
                    String message = String.format("Duplicate substance '%s' with equipment type '%s' found in %s. Each substance+equipment combination must be unique.", substanceName, equipmentType, context);
                    throw new DuplicateValidationException("substance+equipment", combination, context, message);
                }
                seenCombinations.add((CallSite)((Object)combination));
            }
        }
    }

    private static Set<String> getEnabledEquipmentTypes(ParsedSubstance substance) {
        HashSet<String> equipmentTypes = new HashSet<String>();
        for (Operation operation : substance.getOperations()) {
            if (!(operation instanceof EnableOperation)) continue;
            EnableOperation enableOp = (EnableOperation)operation;
            String streamName = enableOp.getStream();
            equipmentTypes.add(streamName);
        }
        return equipmentTypes;
    }
}

