/*
 * Decompiled with CFR 0.152.
 */
package org.kigalisim.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class UnitStringNormalizer {
    private static final Map<String, String> NORMALIZATION_CACHE = new ConcurrentHashMap<String, String>(64);
    private static final int MAX_CACHE_SIZE = 100;

    private UnitStringNormalizer() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static String normalize(String unitString) {
        String cached = NORMALIZATION_CACHE.get(unitString);
        if (cached != null) {
            return cached;
        }
        String normalized = unitString.replace(" ", "");
        if (NORMALIZATION_CACHE.size() < 100) {
            NORMALIZATION_CACHE.put(unitString, normalized);
        }
        return normalized;
    }
}

