/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.teavm.rhino.javascript.Node;
import org.teavm.rhino.javascript.ast.ArrayComprehension;
import org.teavm.rhino.javascript.ast.ArrayComprehensionLoop;
import org.teavm.rhino.javascript.ast.ArrayLiteral;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.AstRoot;
import org.teavm.rhino.javascript.ast.Block;
import org.teavm.rhino.javascript.ast.BreakStatement;
import org.teavm.rhino.javascript.ast.CatchClause;
import org.teavm.rhino.javascript.ast.ConditionalExpression;
import org.teavm.rhino.javascript.ast.ContinueStatement;
import org.teavm.rhino.javascript.ast.DoLoop;
import org.teavm.rhino.javascript.ast.ElementGet;
import org.teavm.rhino.javascript.ast.EmptyExpression;
import org.teavm.rhino.javascript.ast.EmptyStatement;
import org.teavm.rhino.javascript.ast.ExpressionStatement;
import org.teavm.rhino.javascript.ast.ForInLoop;
import org.teavm.rhino.javascript.ast.ForLoop;
import org.teavm.rhino.javascript.ast.FunctionCall;
import org.teavm.rhino.javascript.ast.FunctionNode;
import org.teavm.rhino.javascript.ast.GeneratorExpression;
import org.teavm.rhino.javascript.ast.GeneratorExpressionLoop;
import org.teavm.rhino.javascript.ast.IfStatement;
import org.teavm.rhino.javascript.ast.InfixExpression;
import org.teavm.rhino.javascript.ast.KeywordLiteral;
import org.teavm.rhino.javascript.ast.LabeledStatement;
import org.teavm.rhino.javascript.ast.LetNode;
import org.teavm.rhino.javascript.ast.Loop;
import org.teavm.rhino.javascript.ast.Name;
import org.teavm.rhino.javascript.ast.NewExpression;
import org.teavm.rhino.javascript.ast.NumberLiteral;
import org.teavm.rhino.javascript.ast.ObjectLiteral;
import org.teavm.rhino.javascript.ast.ObjectProperty;
import org.teavm.rhino.javascript.ast.ParenthesizedExpression;
import org.teavm.rhino.javascript.ast.PropertyGet;
import org.teavm.rhino.javascript.ast.RegExpLiteral;
import org.teavm.rhino.javascript.ast.ReturnStatement;
import org.teavm.rhino.javascript.ast.Scope;
import org.teavm.rhino.javascript.ast.StringLiteral;
import org.teavm.rhino.javascript.ast.SwitchCase;
import org.teavm.rhino.javascript.ast.SwitchStatement;
import org.teavm.rhino.javascript.ast.ThrowStatement;
import org.teavm.rhino.javascript.ast.TryStatement;
import org.teavm.rhino.javascript.ast.UnaryExpression;
import org.teavm.rhino.javascript.ast.UpdateExpression;
import org.teavm.rhino.javascript.ast.VariableDeclaration;
import org.teavm.rhino.javascript.ast.VariableInitializer;
import org.teavm.rhino.javascript.ast.WhileLoop;

public class AstVisitor {
    protected AstNode replacement;
    protected boolean hasReplacement;
    protected final Map<String, Scope> currentScopes = new HashMap<String, Scope>();
    private static final Supplier<AstNode> NULL_DEFAULT = () -> new KeywordLiteral(0, 0, 42);
    private static final Supplier<AstNode> EMPTY_DEFAULT = () -> new EmptyStatement(0, 0);
    private static final Supplier<AstNode> EMPTY_EXPR_DEFAULT = () -> new EmptyExpression(0, 0);

    public final void visit(AstNode node) {
        switch (node.getType()) {
            case 140: {
                this.visit((AstRoot)node);
                break;
            }
            case 30: 
            case 38: {
                this.visit((FunctionCall)node);
                break;
            }
            case 113: {
                this.visit((FunctionNode)node);
                break;
            }
            case 161: {
                this.visit((ArrayComprehension)node);
                break;
            }
            case 33: {
                this.visit((PropertyGet)node);
                break;
            }
            case 166: {
                this.visit((GeneratorExpression)node);
                break;
            }
            case 40: {
                this.visit((NumberLiteral)node);
                break;
            }
            case 41: {
                this.visit((StringLiteral)node);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.visit((KeywordLiteral)node);
                break;
            }
            case 39: {
                this.visit((Name)node);
                break;
            }
            case 48: {
                this.visit((RegExpLiteral)node);
                break;
            }
            case 67: {
                this.visit((ObjectLiteral)node);
                break;
            }
            case 66: {
                this.visit((ArrayLiteral)node);
                break;
            }
            case 133: {
                if (node instanceof Block) {
                    this.visit((Block)node);
                    break;
                }
                if (!(node instanceof Scope)) break;
                this.visit((Scope)node);
                break;
            }
            case 106: {
                this.visit((ConditionalExpression)node);
                break;
            }
            case 36: {
                this.visit((ElementGet)node);
                break;
            }
            case 162: {
                this.visit((LetNode)node);
                break;
            }
            case 90: {
                this.visit((ParenthesizedExpression)node);
                break;
            }
            case 132: {
                if (node instanceof EmptyExpression) {
                    this.visit((EmptyExpression)node);
                    break;
                }
                if (!(node instanceof EmptyStatement)) break;
                this.visit((EmptyStatement)node);
                break;
            }
            case 137: 
            case 138: {
                if (node instanceof ExpressionStatement) {
                    this.visit((ExpressionStatement)node);
                    break;
                }
                if (!(node instanceof LabeledStatement)) break;
                this.visit((LabeledStatement)node);
                break;
            }
            case 124: {
                this.visit((BreakStatement)node);
                break;
            }
            case 125: {
                this.visit((ContinueStatement)node);
                break;
            }
            case 4: {
                this.visit((ReturnStatement)node);
                break;
            }
            case 122: {
                this.visit((DoLoop)node);
                break;
            }
            case 123: {
                if (node instanceof ForInLoop) {
                    this.visit((ForInLoop)node);
                    break;
                }
                if (!(node instanceof ForLoop)) break;
                this.visit((ForLoop)node);
                break;
            }
            case 116: {
                this.visit((IfStatement)node);
                break;
            }
            case 118: {
                this.visit((SwitchStatement)node);
                break;
            }
            case 50: {
                this.visit((ThrowStatement)node);
                break;
            }
            case 84: {
                this.visit((TryStatement)node);
                break;
            }
            case 126: 
            case 157: 
            case 158: {
                this.visit((VariableDeclaration)node);
                break;
            }
            case 121: {
                this.visit((WhileLoop)node);
                break;
            }
            default: {
                if (node instanceof InfixExpression) {
                    this.visit((InfixExpression)node);
                    break;
                }
                if (node instanceof UnaryExpression) {
                    this.visit((UnaryExpression)node);
                    break;
                }
                if (!(node instanceof UpdateExpression)) break;
                this.visit((UpdateExpression)node);
            }
        }
    }

    protected final void visitMany(List<AstNode> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            AstNode node = nodes.get(i);
            this.visit(node);
            if (this.hasReplacement) {
                nodes.set(i, this.replacement);
            }
            this.hasReplacement = false;
            this.replacement = null;
        }
    }

    protected final void visitChildren(AstNode node) {
        Node child = node.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            this.visit((AstNode)child);
            if (this.hasReplacement) {
                if (this.replacement != null) {
                    node.replaceChild(child, this.replacement);
                } else {
                    node.removeChild(child);
                }
                this.replacement = null;
                this.hasReplacement = false;
            }
            child = next;
        }
    }

    protected final <T extends AstNode, S extends AstNode> void visitProperty(T owner, Function<T, S> getter, BiConsumer<T, S> setter) {
        this.visitProperty(owner, getter, setter, null);
    }

    protected final <T extends AstNode, S extends AstNode> void visitProperty(T owner, Function<T, S> getter, BiConsumer<T, S> setter, Supplier<S> defaultValue) {
        AstNode node = (AstNode)getter.apply(owner);
        if (node != null) {
            this.visit(node);
            if (this.hasReplacement) {
                if (this.replacement == null && defaultValue != null) {
                    this.replacement = (AstNode)defaultValue.get();
                }
                setter.accept(owner, this.replacement);
            }
            this.replacement = null;
            this.hasReplacement = false;
        }
    }

    public void visit(AstRoot node) {
        this.visitChildren(node);
    }

    public void visit(Block node) {
        this.visitChildren(node);
    }

    public void visit(Scope node) {
        Map<String, Scope> scope = this.enterScope(node);
        this.visitChildren(node);
        this.leaveScope(node, scope);
    }

    public void visit(LabeledStatement node) {
        this.visitProperty(node, LabeledStatement::getStatement, LabeledStatement::setStatement, EMPTY_DEFAULT);
    }

    public void visit(BreakStatement node) {
    }

    public void visit(ContinueStatement node) {
    }

    public void visit(ReturnStatement node) {
        this.visitProperty(node, ReturnStatement::getReturnValue, ReturnStatement::setReturnValue);
    }

    public void visit(ThrowStatement node) {
        this.visitProperty(node, ThrowStatement::getExpression, ThrowStatement::setExpression, () -> new KeywordLiteral(0, 0, 42));
    }

    public void visit(DoLoop node) {
        Map<String, Scope> scope = this.enterScope(node);
        this.visitProperty(node, Loop::getBody, Loop::setBody, EMPTY_DEFAULT);
        this.visitProperty(node, DoLoop::getCondition, DoLoop::setCondition, NULL_DEFAULT);
        this.leaveScope(node, scope);
    }

    public void visit(ForInLoop node) {
        Map<String, Scope> scope = this.enterScope(node);
        this.visitProperty(node, ForInLoop::getIterator, ForInLoop::setIterator, NULL_DEFAULT);
        this.visitProperty(node, ForInLoop::getIteratedObject, ForInLoop::setIteratedObject, NULL_DEFAULT);
        this.visitProperty(node, Loop::getBody, Loop::setBody, EMPTY_DEFAULT);
        this.leaveScope(node, scope);
    }

    public void visit(ForLoop node) {
        Map<String, Scope> scope = this.enterScope(node);
        this.visitProperty(node, ForLoop::getInitializer, ForLoop::setInitializer, EMPTY_EXPR_DEFAULT);
        this.visitProperty(node, ForLoop::getCondition, ForLoop::setCondition, EMPTY_EXPR_DEFAULT);
        this.visitProperty(node, ForLoop::getIncrement, ForLoop::setIncrement, EMPTY_EXPR_DEFAULT);
        this.visitProperty(node, Loop::getBody, Loop::setBody, EMPTY_DEFAULT);
        this.leaveScope(node, scope);
    }

    public void visit(WhileLoop node) {
        Map<String, Scope> scope = this.enterScope(node);
        this.visitProperty(node, WhileLoop::getCondition, WhileLoop::setCondition, NULL_DEFAULT);
        this.visitProperty(node, Loop::getBody, Loop::setBody, EMPTY_DEFAULT);
        this.leaveScope(node, scope);
    }

    public void visit(IfStatement node) {
        this.visitProperty(node, IfStatement::getCondition, IfStatement::setCondition, NULL_DEFAULT);
        this.visitProperty(node, IfStatement::getThenPart, IfStatement::setThenPart, EMPTY_DEFAULT);
        this.visitProperty(node, IfStatement::getElsePart, IfStatement::setElsePart);
    }

    public void visit(SwitchStatement node) {
        this.visitProperty(node, SwitchStatement::getExpression, SwitchStatement::setExpression, NULL_DEFAULT);
        for (SwitchCase sc : node.getCases()) {
            this.visitProperty(sc, SwitchCase::getExpression, SwitchCase::setExpression);
            if (sc.getStatements() == null) continue;
            this.visitMany(sc.getStatements());
        }
    }

    public void visit(TryStatement node) {
        this.visitProperty(node, TryStatement::getTryBlock, TryStatement::setTryBlock, NULL_DEFAULT);
        for (CatchClause cc : node.getCatchClauses()) {
            this.visitProperty(cc, CatchClause::getVarName, CatchClause::setVarName);
            this.visitProperty(cc, CatchClause::getCatchCondition, CatchClause::setCatchCondition);
            if (cc.getBody() == null) continue;
            this.visitChildren(cc.getBody());
        }
        this.visitProperty(node, TryStatement::getFinallyBlock, TryStatement::setFinallyBlock);
    }

    public void visit(VariableDeclaration node) {
        for (VariableInitializer variable : node.getVariables()) {
            this.visit(variable);
        }
    }

    public void visit(VariableInitializer node) {
        this.visitProperty(node, VariableInitializer::getTarget, VariableInitializer::setTarget);
        this.visitProperty(node, VariableInitializer::getInitializer, VariableInitializer::setInitializer);
    }

    public void visit(ExpressionStatement node) {
        this.visitProperty(node, ExpressionStatement::getExpression, ExpressionStatement::setExpression, NULL_DEFAULT);
    }

    public void visit(ElementGet node) {
        this.visitProperty(node, ElementGet::getTarget, ElementGet::setTarget, NULL_DEFAULT);
        this.visitProperty(node, ElementGet::getElement, ElementGet::setElement, NULL_DEFAULT);
    }

    public void visit(PropertyGet node) {
        this.visitProperty(node, PropertyGet::getTarget, PropertyGet::setTarget, NULL_DEFAULT);
        this.visitProperty(node, PropertyGet::getProperty, PropertyGet::setProperty);
    }

    public void visit(FunctionCall node) {
        this.visitProperty(node, FunctionCall::getTarget, FunctionCall::setTarget);
        this.visitMany(node.getArguments());
        if (node instanceof NewExpression) {
            NewExpression newExpr = (NewExpression)node;
            this.visitProperty(newExpr, NewExpression::getInitializer, NewExpression::setInitializer);
        }
    }

    public void visit(ConditionalExpression node) {
        this.visitProperty(node, ConditionalExpression::getTestExpression, ConditionalExpression::setTestExpression);
        this.visitProperty(node, ConditionalExpression::getTrueExpression, ConditionalExpression::setTrueExpression);
        this.visitProperty(node, ConditionalExpression::getFalseExpression, ConditionalExpression::setFalseExpression);
    }

    public void visit(ArrayComprehension node) {
        Map<String, Scope> scope = this.enterScope(node);
        for (ArrayComprehensionLoop loop : node.getLoops()) {
            this.visitProperty(loop, ForInLoop::getIterator, ForInLoop::setIterator);
            this.visitProperty(loop, ForInLoop::getIteratedObject, ForInLoop::setIteratedObject);
        }
        this.visitProperty(node, ArrayComprehension::getFilter, ArrayComprehension::setFilter);
        this.visitProperty(node, ArrayComprehension::getResult, ArrayComprehension::setResult);
        this.leaveScope(node, scope);
    }

    public void visit(GeneratorExpression node) {
        Map<String, Scope> scope = this.enterScope(node);
        for (GeneratorExpressionLoop loop : node.getLoops()) {
            this.visitProperty(loop, ForInLoop::getIterator, ForInLoop::setIterator);
            this.visitProperty(loop, ForInLoop::getIteratedObject, ForInLoop::setIteratedObject);
        }
        this.visitProperty(node, GeneratorExpression::getFilter, GeneratorExpression::setFilter);
        this.visitProperty(node, GeneratorExpression::getResult, GeneratorExpression::setResult);
        this.leaveScope(node, scope);
    }

    public void visit(NumberLiteral node) {
    }

    public void visit(StringLiteral node) {
    }

    public void visit(KeywordLiteral node) {
    }

    public void visit(Name node) {
    }

    public void visit(RegExpLiteral node) {
    }

    public void visit(ArrayLiteral node) {
        this.visitMany(node.getElements());
    }

    public void visit(ObjectLiteral node) {
        if (node.getElements() != null) {
            for (ObjectProperty element : node.getElements()) {
                this.visit(element);
            }
        }
    }

    public void visit(ObjectProperty node) {
        this.visitProperty(node, InfixExpression::getLeft, InfixExpression::setLeft);
        this.visitProperty(node, InfixExpression::getRight, InfixExpression::setRight);
    }

    public void visit(FunctionNode node) {
        Map<String, Scope> scope = this.enterScope(node);
        if (node.getFunctionType() != 4) {
            this.currentScopes.put("arguments", node);
        }
        this.visitProperty(node, FunctionNode::getFunctionName, FunctionNode::setFunctionName);
        this.visitMany(node.getParams());
        this.visitChildren(node.getBody());
        this.leaveScope(node, scope);
    }

    public void visit(LetNode node) {
        Map<String, Scope> scope = this.enterScope(node);
        this.visitProperty(node, LetNode::getVariables, LetNode::setVariables);
        this.visitProperty(node, LetNode::getBody, LetNode::setBody);
        this.leaveScope(node, scope);
    }

    public void visit(ParenthesizedExpression node) {
        this.visitProperty(node, ParenthesizedExpression::getExpression, ParenthesizedExpression::setExpression);
    }

    public void visit(EmptyExpression node) {
    }

    public void visit(EmptyStatement node) {
    }

    public void visit(InfixExpression node) {
        this.visitProperty(node, InfixExpression::getLeft, InfixExpression::setLeft);
        this.visitProperty(node, InfixExpression::getRight, InfixExpression::setRight);
    }

    public void visit(UnaryExpression node) {
        this.visitProperty(node, UnaryExpression::getOperand, UnaryExpression::setOperand);
    }

    public void visit(UpdateExpression node) {
        this.visitProperty(node, UpdateExpression::getOperand, UpdateExpression::setOperand);
    }

    protected final void replaceWith(AstNode node) {
        this.hasReplacement = true;
        this.replacement = node;
    }

    private Map<String, Scope> enterScope(Scope scope) {
        this.onEnterScope(scope);
        if (scope.getSymbolTable() == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Scope> map = new LinkedHashMap<String, Scope>();
        for (String name : scope.getSymbolTable().keySet()) {
            map.put(name, this.currentScopes.get(name));
            this.currentScopes.put(name, scope);
        }
        return map;
    }

    protected void onEnterScope(Scope scope) {
    }

    private void leaveScope(Scope scope, Map<String, Scope> backup) {
        this.onLeaveScope(scope);
        for (Map.Entry<String, Scope> entry : backup.entrySet()) {
            if (entry.getValue() == null) {
                this.currentScopes.remove(entry.getKey());
                continue;
            }
            this.currentScopes.put(entry.getKey(), entry.getValue());
        }
    }

    protected void onLeaveScope(Scope scope) {
    }

    protected Scope scopeOfId(String id) {
        return this.currentScopes.get(id);
    }
}

