/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.runtime.fs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.teavm.backend.wasm.runtime.WasiBuffer;
import org.teavm.backend.wasm.runtime.fs.WasiFileSystem;
import org.teavm.backend.wasm.runtime.fs.WasiVirtualFileAccessor;
import org.teavm.backend.wasm.wasi.Dirent;
import org.teavm.backend.wasm.wasi.FdResult;
import org.teavm.backend.wasm.wasi.Filestat;
import org.teavm.backend.wasm.wasi.IntResult;
import org.teavm.backend.wasm.wasi.Wasi;
import org.teavm.interop.Address;
import org.teavm.interop.Structure;
import org.teavm.runtime.fs.VirtualFile;
import org.teavm.runtime.fs.VirtualFileAccessor;

public class WasiVirtualFile
implements VirtualFile {
    private final WasiFileSystem fs;
    private final String fullPath;
    private boolean initialized;
    private int baseFd;
    private String path;

    WasiVirtualFile(WasiFileSystem fs, String path) {
        this.fs = fs;
        this.fullPath = path;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.fs.findBestPreopened(this.fullPath);
        this.path = this.fs.bestPreopenedPath;
        this.baseFd = this.fs.bestPreopenedId;
        this.fs.bestPreopenedPath = null;
    }

    @Override
    public String getName() {
        return this.path.substring(this.path.lastIndexOf(47) + 1);
    }

    Stat stat() {
        short errno;
        this.init();
        if (this.baseFd < 0) {
            return null;
        }
        Filestat filestat = (Filestat)WasiBuffer.getBuffer().toStructure();
        if (this.path != null) {
            byte[] bytes = this.path.getBytes(StandardCharsets.UTF_8);
            errno = Wasi.pathFilestatGet(this.baseFd, 1, Address.ofData(bytes), bytes.length, filestat);
        } else {
            errno = Wasi.fdFilestatGet(this.baseFd, filestat);
        }
        if (errno == 0) {
            return new Stat((byte)filestat.fileType, filestat.lastModified, filestat.size);
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        Stat stat = this.stat();
        return stat != null && stat.filetype == 3;
    }

    @Override
    public boolean isFile() {
        Stat stat = this.stat();
        return stat != null && stat.filetype == 4;
    }

    /*
     * Unable to fully structure code
     */
    private String[] listFiles(int fd) {
        sizePtr = (IntResult)WasiBuffer.getBuffer().toStructure();
        list = new ArrayList<String>();
        direntSize = Structure.sizeOf(Dirent.class);
        direntArray = this.fs.buffer;
        direntBuffer = Address.align(Address.ofData(direntArray), 8);
        direntArrayOffset = (int)direntBuffer.diff(Address.ofData(direntArray));
        bufferSize = direntArray.length - direntArrayOffset;
        cookie = 0L;
        block0: while (true) {
            if ((errno = Wasi.fdReaddir(fd, direntBuffer, bufferSize, cookie, sizePtr)) != 0) {
                return null;
            }
            size = sizePtr.value;
            remainingSize = bufferSize;
            entryOffset = 0;
            do {
                if (remainingSize < direntSize) continue block0;
                direntPtr = direntBuffer.add(entryOffset);
                dirent = (Dirent)direntPtr.toStructure();
                entryLength = direntSize + dirent.nameLength;
                if (entryLength > bufferSize) {
                    direntArray = new byte[entryLength * 3 / 2 + 8];
                    direntBuffer = Address.align(Address.ofData(direntArray), 8);
                    direntArrayOffset = (int)direntBuffer.diff(Address.ofData(direntArray));
                    bufferSize = direntArray.length - direntArrayOffset;
                    continue block0;
                }
                if (entryOffset + entryLength <= bufferSize) ** break;
                continue block0;
                cookie = dirent.next;
                name = new String(direntArray, direntArrayOffset + entryOffset + direntSize, dirent.nameLength, StandardCharsets.UTF_8);
                if (!name.equals(".") && !name.equals("..")) {
                    list.add(name);
                }
                remainingSize -= entryLength;
            } while ((entryOffset += entryLength) != size);
            break;
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String[] listFiles() {
        int fd;
        this.init();
        if (this.baseFd < 0) {
            return null;
        }
        int n = fd = this.path != null ? this.open((short)2, 16386L, (short)0) : this.baseFd;
        if (fd < 0) {
            return null;
        }
        try {
            String[] stringArray = this.listFiles(fd);
            return stringArray;
        }
        finally {
            if (this.path != null) {
                WasiVirtualFile.close(fd);
            }
        }
    }

    private int open(int fd, String path, short oflags, long rights, short fdflags) {
        byte[] bytes = path.getBytes(StandardCharsets.UTF_8);
        FdResult fdPtr = (FdResult)WasiBuffer.getBuffer().toStructure();
        this.fs.errno = Wasi.pathOpen(fd, 1, Address.ofData(bytes), bytes.length, oflags, rights, rights, fdflags, fdPtr);
        return this.fs.errno == 0 ? fdPtr.value : -1;
    }

    private int open(short oflags, long rights, short fdflags) {
        return this.open(this.baseFd, this.path, oflags, rights, fdflags);
    }

    private static void close(int fd) {
        Wasi.fdClose(fd);
    }

    @Override
    public VirtualFileAccessor createAccessor(boolean readable, boolean writable, boolean append) {
        int fd;
        this.init();
        if (this.baseFd < 0) {
            return null;
        }
        long rights = 0L;
        if (readable) {
            rights |= 0x200026L;
        }
        if (writable) {
            rights |= 0x400050L;
        }
        short fdflags = 0;
        if (append) {
            fdflags = (short)(fdflags | 1);
        }
        return (fd = this.open((short)0, rights, fdflags)) >= 0 ? new WasiVirtualFileAccessor(this, fd) : null;
    }

    @Override
    public boolean createFile(String fileName) throws IOException {
        this.init();
        if (this.baseFd < 0) {
            throw new IOException("Can't create file: access to directory not granted by WASI runtime");
        }
        int fd = this.open(this.baseFd, this.constructPath(this.path, fileName), (short)5, 0L, (short)0);
        if (this.fs.errno == 20) {
            return false;
        }
        if (this.fs.errno != 0) {
            throw new IOException("fd_open: " + this.fs.errno);
        }
        WasiVirtualFile.close(fd);
        return true;
    }

    @Override
    public boolean createDirectory(String fileName) {
        this.init();
        if (this.baseFd < 0) {
            return false;
        }
        String filePath = this.constructPath(this.path, fileName);
        byte[] bytes = filePath.getBytes(StandardCharsets.UTF_8);
        return Wasi.pathCreateDirectory(this.baseFd, Address.ofData(bytes), bytes.length) == 0;
    }

    @Override
    public boolean delete() {
        this.init();
        if (this.path == null || this.baseFd < 0) {
            return false;
        }
        if (this.isFile()) {
            byte[] bytes = this.path.getBytes(StandardCharsets.UTF_8);
            return Wasi.pathUnlinkFile(this.baseFd, Address.ofData(bytes), bytes.length) == 0;
        }
        if (this.isDirectory()) {
            byte[] bytes = this.path.getBytes(StandardCharsets.UTF_8);
            return Wasi.pathRemoveDirectory(this.baseFd, Address.ofData(bytes), bytes.length) == 0;
        }
        return false;
    }

    private static boolean adopt(int fd, WasiVirtualFile file, String fileName) {
        byte[] newBytes = fileName.getBytes(StandardCharsets.UTF_8);
        byte[] oldBytes = file.path.getBytes(StandardCharsets.UTF_8);
        short errno = Wasi.pathRename(file.baseFd, Address.ofData(oldBytes), oldBytes.length, fd, Address.ofData(newBytes), newBytes.length);
        return errno == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean adopt(VirtualFile file, String fileName) {
        if (!(file instanceof WasiVirtualFile)) {
            return false;
        }
        WasiVirtualFile wasiFile = (WasiVirtualFile)file;
        wasiFile.init();
        if (wasiFile.path == null || fileName == null) {
            return false;
        }
        this.init();
        if (this.baseFd < 0) {
            return false;
        }
        if (this.path == null) {
            return WasiVirtualFile.adopt(this.baseFd, wasiFile, fileName);
        }
        int fd = this.open((short)2, 66L, (short)0);
        try {
            boolean bl = WasiVirtualFile.adopt(fd, wasiFile, fileName);
            return bl;
        }
        finally {
            WasiVirtualFile.close(fd);
        }
    }

    @Override
    public boolean canRead() {
        this.init();
        int fd = this.open((short)0, 2L, (short)0);
        if (fd >= 0) {
            WasiVirtualFile.close(fd);
            return true;
        }
        return false;
    }

    @Override
    public boolean canWrite() {
        this.init();
        int fd = this.open((short)0, 64L, (short)0);
        if (fd >= 0) {
            WasiVirtualFile.close(fd);
            return true;
        }
        return false;
    }

    @Override
    public long lastModified() {
        Stat stat = this.stat();
        return stat == null ? 0L : stat.mtime / 1000000L;
    }

    @Override
    public boolean setLastModified(long lastModified) {
        short errno;
        this.init();
        if (this.baseFd < 0) {
            return false;
        }
        if (this.path == null) {
            errno = Wasi.fdFilestatSetTimes(this.baseFd, 0L, lastModified * 1000000L, (short)4);
        } else {
            byte[] bytes = this.path.getBytes(StandardCharsets.UTF_8);
            errno = Wasi.pathFilestatSetTimes(this.baseFd, 1, Address.ofData(bytes), bytes.length, 0L, lastModified * 1000000L, (short)4);
        }
        return errno == 0;
    }

    @Override
    public boolean setReadOnly(boolean readOnly) {
        return false;
    }

    @Override
    public int length() {
        Stat stat = this.stat();
        return stat == null ? 0 : (int)stat.filesize;
    }

    private String constructPath(String parent, String child) {
        if (parent == null) {
            return child;
        }
        return !parent.isEmpty() && parent.charAt(parent.length() - 1) == '/' ? parent + child : parent + "/" + child;
    }

    static class Stat {
        final byte filetype;
        final long mtime;
        final long filesize;

        Stat(byte filetype, long mtime, long filesize) {
            this.filetype = filetype;
            this.mtime = mtime;
            this.filesize = filesize;
        }
    }
}

