/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.Arrays;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphSplittingBackend;
import org.teavm.common.GraphUtils;
import org.teavm.common.MutableDirectedGraph;
import org.teavm.hppc.IntArrayList;

class IrreducibleGraphSplitter {
    private GraphSplittingBackend backend;
    private DominatorTree dom;
    private int[][] domNodes;
    private MutableDirectedGraph cfg;
    private int[] weights;
    private IntArrayList[] realNodes;
    private int[][] spBackEdges;
    private int[] tmpArray;
    private int[] tmpArray2;
    private IntArrayList copiedRealNodes = new IntArrayList();
    private int additionalWeight;
    private int[] collapseMap;

    IrreducibleGraphSplitter(GraphSplittingBackend backend, Graph src, int[] weights) {
        this(backend, src, weights, IrreducibleGraphSplitter.initRealNodes(src.size()));
    }

    private static int[][] initRealNodes(int size) {
        int[][] result = new int[size][];
        for (int i = 0; i < size; ++i) {
            result[i] = new int[]{i};
        }
        return result;
    }

    private IrreducibleGraphSplitter(GraphSplittingBackend backend, Graph src, int[] weights, int[][] realNodes) {
        int i;
        int size = src.size();
        if (size != weights.length || size != realNodes.length) {
            throw new IllegalArgumentException("Node count " + src.size() + " is not equal to weight array " + weights.length);
        }
        this.backend = backend;
        this.tmpArray = new int[src.size()];
        this.tmpArray2 = new int[src.size()];
        this.cfg = new MutableDirectedGraph(src);
        this.dom = GraphUtils.buildDominatorTree(src);
        this.collapseMap = new int[size];
        for (i = 0; i < size; ++i) {
            this.collapseMap[i] = i;
        }
        this.buildDomGraph();
        this.dfs();
        this.realNodes = new IntArrayList[realNodes.length];
        for (i = 0; i < this.cfg.size(); ++i) {
            this.realNodes[i] = IntArrayList.from(realNodes[i]);
        }
        this.weights = (int[])weights.clone();
    }

    private void buildDomGraph() {
        int i;
        int size = this.cfg.size();
        int[] domGraphCount = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            int j = this.dom.immediateDominatorOf(i2);
            if (j < 0) continue;
            int n = j;
            domGraphCount[n] = domGraphCount[n] + 1;
        }
        int[][] domGraph = new int[size][];
        for (i = 0; i < size; ++i) {
            domGraph[i] = new int[domGraphCount[i]];
            domGraphCount[i] = 0;
        }
        for (i = 0; i < size; ++i) {
            int j = this.dom.immediateDominatorOf(i);
            if (j < 0) continue;
            int n = j;
            int n2 = domGraphCount[n];
            domGraphCount[n] = n2 + 1;
            domGraph[j][n2] = i;
        }
        this.domNodes = domGraph;
    }

    private void dfs() {
        int size = this.cfg.size();
        this.spBackEdges = new int[size][];
        int[] spBackEdgeCount = new int[size];
        for (int i = 0; i < size; ++i) {
            int count = this.cfg.incomingEdgesCount(i);
            if (count <= 0) continue;
            this.spBackEdges[i] = new int[this.cfg.incomingEdgesCount(i)];
        }
        int[] state = new int[size];
        int[] stack = new int[size * 2];
        int top = 0;
        stack[top++] = 0;
        block5: while (top > 0) {
            int node = stack[--top];
            switch (state[node]) {
                case 0: {
                    state[node] = 1;
                    stack[top++] = node;
                    for (int successor : this.cfg.outgoingEdges(node)) {
                        if (state[successor] == 0) {
                            stack[top++] = successor;
                            continue;
                        }
                        if (state[successor] != 1) continue;
                        int n = successor;
                        int n2 = spBackEdgeCount[n];
                        spBackEdgeCount[n] = n2 + 1;
                        this.spBackEdges[successor][n2] = node;
                    }
                    continue block5;
                }
                case 1: {
                    state[node] = 2;
                }
            }
        }
        for (int i = 0; i < size; ++i) {
            int[] back = this.spBackEdges[i];
            if (back == null) continue;
            int count = spBackEdgeCount[i];
            if (count == 0) {
                this.spBackEdges[i] = null;
                continue;
            }
            if (count >= this.spBackEdges[i].length) continue;
            this.spBackEdges[i] = Arrays.copyOf(back, count);
        }
    }

    void splitLoops() {
        int size = this.cfg.size();
        boolean[] cross = new boolean[size];
        int[] stack = new int[size * 4];
        int head = 0;
        stack[head++] = 0;
        stack[head++] = 0;
        while (head > 0) {
            int state = stack[--head];
            int node = stack[--head];
            if (state == 0) {
                stack[head++] = node;
                stack[head++] = 1;
                int[] successors = this.domNodes[node];
                for (int i = successors.length - 1; i >= 0; --i) {
                    stack[head++] = successors[i];
                    stack[head++] = 0;
                }
                continue;
            }
            if (cross[node]) {
                this.handleIrreducibleChildren(node);
            }
            int[] back = this.spBackEdges[node];
            int parent = this.dom.immediateDominatorOf(node);
            if (back != null && parent >= 0) {
                for (int predecessor : back) {
                    if (this.dom.dominates(node, predecessor)) continue;
                    cross[parent] = true;
                    break;
                }
            }
            if (this.domNodes[node].length <= 1) continue;
            this.collapse(node);
        }
    }

    private void handleIrreducibleChildren(int top) {
        int[][] sccs;
        Graph levelSubgraph = GraphUtils.subgraph(this.cfg, node -> node != top && this.dom.dominates(top, node));
        for (int[] scc : sccs = GraphUtils.findStronglyConnectedComponents(levelSubgraph)) {
            if (scc.length <= 1) continue;
            this.handleStronglyConnectedComponent(top, scc);
        }
    }

    private void handleStronglyConnectedComponent(int top, int[] scc) {
        int domainCount = 0;
        for (int node : scc) {
            if (this.dom.immediateDominatorOf(node) != top) continue;
            ++domainCount;
        }
        if (domainCount < 2) {
            return;
        }
        int[] domains = this.fillDomains(top, scc);
        int[] localWeights = this.fillWeights(domains, scc);
        int remaining = -1;
        int maxWeight = 0;
        for (int node : scc) {
            if (domains[node] != node || remaining >= 0 && localWeights[node] <= maxWeight) continue;
            maxWeight = localWeights[node];
            remaining = node;
        }
        int realRemainingNodesCount = 0;
        int realNodesToCopyCount = 0;
        int copyWeight = 0;
        int remainingNodeCount = 0;
        for (int node : scc) {
            if (domains[node] != remaining) {
                realNodesToCopyCount += this.realNodes[node].size();
                copyWeight += this.weights[node];
                continue;
            }
            ++remainingNodeCount;
            realRemainingNodesCount += this.realNodes[node].size();
        }
        int[] realNodesToCopy = new int[realNodesToCopyCount];
        int[] realRemainingNodes = new int[realRemainingNodesCount];
        realNodesToCopyCount = 0;
        realRemainingNodesCount = 0;
        for (int node : scc) {
            int[] nodes = this.realNodes[node].toArray();
            if (domains[node] != remaining) {
                System.arraycopy(nodes, 0, realNodesToCopy, realNodesToCopyCount, nodes.length);
                realNodesToCopyCount += nodes.length;
                continue;
            }
            System.arraycopy(nodes, 0, realRemainingNodes, realRemainingNodesCount, nodes.length);
            realRemainingNodesCount += nodes.length;
        }
        int[] realNodesCopies = this.backend.split(realRemainingNodes, realNodesToCopy);
        this.copiedRealNodes.add(realNodesCopies);
        int subgraphSize = scc.length * 2 + 1 - remainingNodeCount;
        GraphBuilder subgraph = new GraphBuilder(subgraphSize);
        int[][] subgraphRealNodes = new int[subgraphSize][];
        int[] subgraphWeights = new int[subgraphSize];
        int[] map = new int[this.cfg.size()];
        int[] copyMap = new int[this.cfg.size()];
        Arrays.fill(map, -1);
        Arrays.fill(copyMap, -1);
        subgraphRealNodes[0] = new int[0];
        subgraphWeights[0] = 0;
        for (int i = 0; i < scc.length; ++i) {
            int node = scc[i];
            map[node] = i + 1;
            subgraphRealNodes[i + 1] = this.realNodes[node].toArray();
            subgraphWeights[i + 1] = this.weights[node];
            if (domains[node] != node) continue;
            boolean hasPredecessorsOutsideLoop = false;
            int[] nArray = this.cfg.incomingEdges(node);
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int pred = nArray[j];
                if (domains[pred] >= 0) continue;
                hasPredecessorsOutsideLoop = true;
                break;
            }
            if (!hasPredecessorsOutsideLoop) continue;
            subgraph.addEdge(0, i + 1);
        }
        int copyIndex = scc.length + 1;
        int realNodeCopiesIndex = 0;
        for (int node : scc) {
            if (domains[node] == remaining) continue;
            copyMap[node] = copyIndex;
            int realNodeCount = this.realNodes[node].size();
            subgraphRealNodes[copyIndex] = Arrays.copyOfRange(realNodesCopies, realNodeCopiesIndex, realNodeCopiesIndex + realNodeCount);
            realNodeCopiesIndex += realNodeCount;
            subgraphWeights[copyIndex] = this.weights[node];
            ++copyIndex;
        }
        for (int node : scc) {
            int[] successors;
            int subgraphNode = map[node];
            int subgraphNodeCopy = copyMap[node];
            for (int successor : successors = this.cfg.outgoingEdges(node)) {
                int subgraphSuccessor = map[successor];
                int subgraphSuccessorCopy = copyMap[successor];
                if (subgraphSuccessorCopy >= 0) {
                    if (subgraphNodeCopy >= 0) {
                        subgraph.addEdge(subgraphNodeCopy, subgraphSuccessorCopy);
                        if (subgraphSuccessor < 0) continue;
                        subgraph.addEdge(subgraphNode, subgraphSuccessor);
                        continue;
                    }
                    subgraph.addEdge(subgraphNode, subgraphSuccessorCopy);
                    continue;
                }
                if (subgraphSuccessor < 0) continue;
                if (subgraphNodeCopy >= 0) {
                    subgraph.addEdge(subgraphNodeCopy, subgraphSuccessor);
                }
                subgraph.addEdge(subgraphNode, subgraphSuccessor);
            }
        }
        IrreducibleGraphSplitter subgraphSplitter = new IrreducibleGraphSplitter(this.backend, subgraph.build(), subgraphWeights, subgraphRealNodes);
        subgraphSplitter.splitLoops();
        this.realNodes[top].addAll(subgraphSplitter.copiedRealNodes);
        this.realNodes[top].add(realNodesCopies);
        int n = top;
        this.weights[n] = this.weights[n] + (subgraphSplitter.additionalWeight + copyWeight);
        this.copiedRealNodes.addAll(subgraphSplitter.copiedRealNodes);
        this.additionalWeight += subgraphSplitter.additionalWeight + copyWeight;
    }

    private int[] fillDomains(int top, int[] nodes) {
        int[] domains = this.tmpArray;
        Arrays.fill(domains, -1);
        block0: for (int node : nodes) {
            int domain = domains[node];
            if (domain >= 0) continue;
            while (true) {
                int parent;
                if ((parent = this.dom.immediateDominatorOf(node)) == top) {
                    domain = node;
                    break;
                }
                domain = domains[parent];
                if (domain >= 0) break;
                domains[parent] = node;
                node = parent;
            }
            while (true) {
                int next = domains[node];
                domains[node] = domain;
                if (next == -1) continue block0;
                node = next;
            }
        }
        return domains;
    }

    private int[] fillWeights(int[] domains, int[] nodes) {
        int[] localWeights = this.tmpArray2;
        for (int node : nodes) {
            if (domains[node] != node) continue;
            localWeights[node] = 0;
        }
        for (int node : nodes) {
            int n = domains[node];
            localWeights[n] = localWeights[n] + this.weights[node];
        }
        return localWeights;
    }

    private void collapse(int top) {
        int node;
        int i;
        if (this.domNodes[top] == null || this.domNodes[top].length == 0) {
            return;
        }
        int count = this.findAllDominatedNodes(top);
        int[] nodes = this.tmpArray;
        IntArrayList topRealNodes = this.realNodes[top];
        for (i = 1; i < count; ++i) {
            node = nodes[i];
            topRealNodes.addAll(this.realNodes[node]);
            this.realNodes[node] = null;
            int n = top;
            this.weights[n] = this.weights[n] + this.weights[node];
            this.collapseMap[node] = top;
        }
        for (i = 1; i < count; ++i) {
            node = nodes[i];
            for (int succ : this.cfg.outgoingEdges(node)) {
                int mappedSucc = this.collapseMap[succ];
                if (mappedSucc == top && succ != top) continue;
                this.cfg.addEdge(top, mappedSucc);
            }
            for (int pred : this.cfg.incomingEdges(node)) {
                int mappedPred = this.collapseMap[pred];
                if (mappedPred == top) continue;
                this.cfg.addEdge(mappedPred, top);
            }
            this.cfg.detachNode(node);
        }
        this.domNodes[top] = null;
    }

    private int findAllDominatedNodes(int top) {
        int[] result = this.tmpArray;
        int count = 0;
        result[count++] = top;
        for (int head = 0; head < count; ++head) {
            int[] successors = this.domNodes[result[head]];
            if (successors == null || successors.length <= 0) continue;
            System.arraycopy(successors, 0, result, count, successors.length);
            count += successors.length;
        }
        return count;
    }
}

