/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.hppc;

import java.util.Iterator;
import java.util.function.IntBinaryOperator;
import org.teavm.hppc.AbstractDoubleCollection;
import org.teavm.hppc.AbstractIntCollection;
import org.teavm.hppc.AbstractIterator;
import org.teavm.hppc.DoubleContainer;
import org.teavm.hppc.IntCollection;
import org.teavm.hppc.IntContainer;
import org.teavm.hppc.IntDoubleAssociativeContainer;
import org.teavm.hppc.IntDoubleHashMap;
import org.teavm.hppc.IntDoubleMap;
import org.teavm.hppc.IntLookupContainer;
import org.teavm.hppc.comparators.IntComparator;
import org.teavm.hppc.comparators.IntDoubleComparator;
import org.teavm.hppc.cursors.DoubleCursor;
import org.teavm.hppc.cursors.IntCursor;
import org.teavm.hppc.cursors.IntDoubleCursor;
import org.teavm.hppc.predicates.DoublePredicate;
import org.teavm.hppc.predicates.IntDoublePredicate;
import org.teavm.hppc.predicates.IntPredicate;
import org.teavm.hppc.procedures.DoubleProcedure;
import org.teavm.hppc.procedures.IntDoubleProcedure;
import org.teavm.hppc.procedures.IntProcedure;
import org.teavm.hppc.sorting.QuickSort;

public class SortedIterationIntDoubleHashMap
implements IntDoubleMap {
    public final IntDoubleHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationIntDoubleHashMap(IntDoubleHashMap delegate, IntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationIntDoubleHashMap(IntDoubleHashMap delegate, IntDoubleComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        int[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != 0) {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, IntComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            int[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final IntDoubleComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final int[] keys;
            final double[] values;
            {
                this.keys = SortedIterationIntDoubleHashMap.this.delegate.keys;
                this.values = SortedIterationIntDoubleHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<IntDoubleCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(IntContainer container) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public int removeAll(IntDoublePredicate predicate) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public <T extends IntDoubleProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntDoublePredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        int[] keys = this.delegate.keys;
        double[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public IntCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public DoubleContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public double get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public double getOrDefault(int key, double defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public double put(int key, double value) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(IntDoubleAssociativeContainer container) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends IntDoubleCursor> iterable) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public double putOrAdd(int key, double putValue, double incrementValue) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public double addTo(int key, double additionValue) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public double remove(int key) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public int indexOf(int key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public double indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public double indexReplace(int index, double newValue) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, int key, double value) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public double indexRemove(int index) {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationIntDoubleHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<IntDoubleCursor> {
        private final IntDoubleCursor cursor = new IntDoubleCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected IntDoubleCursor fetch() {
            if (this.index < SortedIterationIntDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationIntDoubleHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationIntDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntDoubleCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final SortedIterationIntDoubleHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationIntDoubleHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationIntDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationIntDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationIntDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final SortedIterationIntDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationIntDoubleHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(double value) {
            for (IntDoubleCursor c : this.owner) {
                if (Double.doubleToLongBits(value) != Double.doubleToLongBits(c.value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(double e) {
            throw SortedIterationIntDoubleHashMap.readOnlyException();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            throw SortedIterationIntDoubleHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationIntDoubleHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationIntDoubleHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor = new DoubleCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected DoubleCursor fetch() {
            if (this.index < SortedIterationIntDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntDoubleHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationIntDoubleHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationIntDoubleHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationIntDoubleHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

