/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import java.util.Arrays;
import org.teavm.interop.AsyncCallback;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Unmanaged;
import org.teavm.interop.UnsupportedOn;
import org.teavm.runtime.EventQueue;

@StaticInit
@UnsupportedOn(value={"webassembly-gc"})
public class Fiber {
    public static final int STATE_RUNNING = 0;
    public static final int STATE_SUSPENDING = 1;
    public static final int STATE_RESUMING = 2;
    public static int userThreadCount = 1;
    private int[] intValues;
    private int intTop;
    private long[] longValues;
    private int longTop;
    private float[] floatValues;
    private int floatTop;
    private double[] doubleValues;
    private int doubleTop;
    private Object[] objectValues;
    private int objectTop;
    private int state;
    private FiberRunner runner;
    private Object result;
    private Throwable exception;
    private boolean daemon;
    private static Fiber current;
    private static PendingCall lastPendingCall;

    private Fiber(FiberRunner runner, boolean daemon) {
        this.runner = runner;
        this.daemon = daemon;
    }

    public void push(int value) {
        if (this.intValues == null) {
            this.intValues = new int[4];
        } else if (this.intTop + 1 == this.intValues.length) {
            this.intValues = Arrays.copyOf(this.intValues, this.intValues.length * 3 / 2);
        }
        this.intValues[this.intTop++] = value;
    }

    public void push(long value) {
        if (this.longValues == null) {
            this.longValues = new long[4];
        } else if (this.longTop + 1 == this.longValues.length) {
            this.longValues = Arrays.copyOf(this.longValues, this.longValues.length * 3 / 2);
        }
        this.longValues[this.longTop++] = value;
    }

    public void push(float value) {
        if (this.floatValues == null) {
            this.floatValues = new float[4];
        } else if (this.floatTop + 1 == this.floatValues.length) {
            this.floatValues = Arrays.copyOf(this.floatValues, this.floatValues.length * 3 / 2);
        }
        this.floatValues[this.floatTop++] = value;
    }

    public void push(double value) {
        if (this.doubleValues == null) {
            this.doubleValues = new double[4];
        } else if (this.doubleTop + 1 == this.doubleValues.length) {
            this.doubleValues = Arrays.copyOf(this.doubleValues, this.doubleValues.length * 3 / 2);
        }
        this.doubleValues[this.doubleTop++] = value;
    }

    public void push(Object value) {
        if (this.objectValues == null) {
            this.objectValues = new Object[4];
        } else if (this.objectTop + 1 == this.objectValues.length) {
            this.objectValues = Arrays.copyOf(this.objectValues, this.objectValues.length * 3 / 2);
        }
        this.objectValues[this.objectTop++] = value;
    }

    @Unmanaged
    public int popInt() {
        return this.intValues[--this.intTop];
    }

    @Unmanaged
    public long popLong() {
        return this.longValues[--this.longTop];
    }

    @Unmanaged
    public float popFloat() {
        return this.floatValues[--this.floatTop];
    }

    @Unmanaged
    public double popDouble() {
        return this.doubleValues[--this.doubleTop];
    }

    @Unmanaged
    public Object popObject() {
        Object result = this.objectValues[--this.objectTop];
        this.objectValues[this.objectTop] = null;
        return result;
    }

    @Unmanaged
    public static Fiber current() {
        return current;
    }

    @Unmanaged
    public boolean isSuspending() {
        return this.state == 1;
    }

    @Unmanaged
    public boolean isResuming() {
        return this.state == 2;
    }

    @Unmanaged
    public static boolean getBoolean(Object v) {
        return v != null ? (Boolean)v : false;
    }

    @Unmanaged
    public static byte getByte(Object v) {
        return v != null ? (Byte)v : (byte)0;
    }

    @Unmanaged
    public static short getShort(Object v) {
        return v != null ? (Short)v : (short)0;
    }

    @Unmanaged
    public static int getInt(Object v) {
        return v != null ? (Integer)v : 0;
    }

    @Unmanaged
    public static char getChar(Object v) {
        return v != null ? ((Character)v).charValue() : (char)'\u0000';
    }

    @Unmanaged
    public static long getLong(Object v) {
        return v != null ? (Long)v : 0L;
    }

    @Unmanaged
    public static float getFloat(Object v) {
        return v != null ? ((Float)v).floatValue() : 0.0f;
    }

    @Unmanaged
    public static double getDouble(Object v) {
        return v != null ? (Double)v : 0.0;
    }

    public static Object suspend(AsyncCall call) throws Throwable {
        Fiber fiber = Fiber.current();
        Thread javaThread = Thread.currentThread();
        if (fiber.isResuming()) {
            fiber.state = 0;
            if (fiber.exception != null) {
                throw fiber.exception;
            }
            return fiber.result;
        }
        PendingCall pendingCall = new PendingCall(call, lastPendingCall);
        if (lastPendingCall != null) {
            Fiber.lastPendingCall.next = pendingCall;
        }
        lastPendingCall = pendingCall;
        fiber.state = 1;
        pendingCall.callback = new AsyncCallbackImpl(pendingCall, javaThread, fiber);
        call.run(pendingCall.callback);
        return null;
    }

    static native void setCurrentThread(Thread var0);

    public static void start(FiberRunner runner, boolean daemon) {
        new Fiber(runner, daemon).start();
    }

    static void startMain(String[] args) {
        Fiber.start(() -> Fiber.runMain(args), false);
    }

    public static native void runMain(String[] var0);

    private void start() {
        Fiber former = current;
        current = this;
        this.runner.run();
        current = former;
        if (!this.isSuspending() && !this.daemon && --userThreadCount == 0) {
            EventQueue.stop();
        }
    }

    void resume() {
        this.state = 2;
        this.start();
    }

    public static interface FiberRunner {
        public void run();
    }

    static class PendingCall {
        AsyncCall value;
        PendingCall next;
        PendingCall previous;
        AsyncCallbackImpl callback;

        PendingCall(AsyncCall value, PendingCall previous) {
            this.value = value;
            this.next = null;
            this.previous = previous;
        }
    }

    public static interface AsyncCall {
        public void run(AsyncCallback<?> var1);
    }

    static class AsyncCallbackImpl
    implements AsyncCallback<Object> {
        PendingCall pendingCall;
        Thread javaThread;
        Fiber fiber;

        AsyncCallbackImpl(PendingCall pendingCall, Thread javaThread, Fiber fiber) {
            this.pendingCall = pendingCall;
            this.javaThread = javaThread;
            this.fiber = fiber;
        }

        @Override
        public void complete(Object result) {
            Fiber.setCurrentThread(this.javaThread);
            this.javaThread = null;
            Fiber fiber = this.fiber;
            this.fiber = null;
            fiber.result = result;
            this.removePendingCall();
            fiber.resume();
        }

        @Override
        public void error(Throwable e) {
            Fiber.setCurrentThread(this.javaThread);
            this.javaThread = null;
            Fiber fiber = this.fiber;
            this.fiber = null;
            fiber.exception = e;
            this.removePendingCall();
            fiber.resume();
        }

        private void removePendingCall() {
            if (this.pendingCall.previous != null) {
                this.pendingCall.previous.next = this.pendingCall.next;
            }
            if (this.pendingCall.next != null) {
                this.pendingCall.next.previous = this.pendingCall.previous;
            }
            if (this.pendingCall == lastPendingCall) {
                lastPendingCall = this.pendingCall.previous;
            }
            this.pendingCall = null;
        }
    }
}

